uniform vec4 camera; // xyz- camera origin(LY)  , w - 1/galaxy_rad(LY)
uniform mat4 modelproj;
in  vec4 pos;
out vec4 dir;
flat out vec4 cs;
flat out vec2 dtex;

void main()
{
 gl_Position = modelproj*vec4(pos.xyz,1.0);
 dir.xyz     = pos.xyz;
 dir.w       = fract(pos.w);
 vec3  v     = normalize(-camera.xyz);
 float lon=atan(v.y,v.x);
 float lat=atan(v.z,length(v.xy));
 cs=vec4(cos(lon),sin(lon),cos(lat),sin(lat));
 dtex=vec2(lon*(2./3.14159265),lat*(2./3.14159265));
}

