version 6
in       vec2 pos;
out      vec2 worldP;
flat out vec3 ssColor;
uniform mat4 modelproj;
uniform vec4  sunDir;
uniform vec4  campos;
uniform vec4  hcloud; //  relative clouds_height , clouds_thickness, clouds_height ,xnorm


void main()
{
 float csx   = cos(pos.x),snx=sin(pos.x);
 float csy   = cos(pos.y),sny=sin(pos.y);
 vec3    p   = vec3(csy * snx,sny,csy * csx);
 vec4    v   = vec4(p*(earthRadius+hcloud.z),1.0);
 // v.z        -= earthRadius;

 v.z=(v.z-earthRadius-hcloud.z)*clamp(campos.z/30000.0,0.0,1.0)+hcloud.z;

 worldP      = v.xy;
 gl_Position = modelproj*v;
 vec3 Lsun;
 vec3 Esky;
 sunRadianceAndSkyIrradiance(sunDir.xyz, Lsun, Esky);
 ssColor=(Lsun * max(sunDir.z, 0.0) + Esky * 0.1) *(1.0/ M_PI);
}
