version 4
const int nlayers=5;

/*layout(binding = 10)*/ uniform sampler2D butterflySampler;
uniform sampler2DArray img; // 2 complex inputs (= 4 values) per layer
uniform float          pass;
out vec4 fragdata[nlayers];
in  vec2 uv;

void main()
{
 vec4 data = texture(butterflySampler, vec2(uv.y, pass));
 for (int i=0;i<nlayers;i++)
 {
  vec4 input1 = texture(img, vec3(uv.x, data.x, float(i)));
  vec4 input2 = texture(img, vec3(uv.x, data.y, float(i)));
  float res1x = data.z * input2.x - data.w * input2.y;
  float res1y = data.w * input2.x + data.z * input2.y;
  float res2x = data.z * input2.z - data.w * input2.w;
  float res2y = data.w * input2.z + data.z * input2.w;
  fragdata[i] = input1 + vec4(res1x, res1y, res2x, res2y);
 }
}
