#extension GL_EXT_geometry_shader4 : enable
layout (points) in;
layout (triangle_strip, max_vertices = 4) out;

uniform mat4 projection;
uniform vec4 ks;    // k,scale,aster_visibility,inv_scr_nx
uniform vec4 lhtpos;  // lhtpos,time
in  vec3 _pos[];
flat out float rock,alpha,ratio,seed;
flat out vec4 camera;
flat out vec4 cs;
flat out vec3 lvec;
out vec2 vx;

void  emit(vec3 p,vec2 d,float size)
{
 vx   =d;
 p.xy+=d*size;
 gl_Position = projection*vec4(p,1.0);
 EmitVertex();
}

const float pixrad_min=3.0;
const float pixrad_max=80.0;
const float q1=8.0,q2=.25; // const float q1=2.0,q2=.5;

void main()
{
 lvec         = normalize(lhtpos.xyz-_pos[0]);
 float    rad  = gl_PositionIn[0].w*.5;
 float dist_max= rad*ks.y/(pixrad_min*ks.w);
 float dist_min= rad     /(pixrad_max*ks.w);
 float t       = (length(gl_PositionIn[0].xyz)-dist_min)*q1/(dist_max-dist_min);
 if (t>.5)   t = pow(t/q1,q2);
 float tc      = clamp(t,0.,2.);
 float scale   = mix(1.0,ks.y,tc);
 rad          *= scale;
 alpha         = clamp(1.-(t-1.)*ks.z,0.,1.);

 ratio        = clamp(.525+gl_PositionIn[0].w*1.0e-6,0.7,1.0);
 rock         = .15/ratio;
 seed         = 500.545+fract(gl_PositionIn[0].w*1.0e-2)*300.;
 camera.xyz   = -gl_PositionIn[0].xyz;
 camera.w     = 1./rad; // 1/ (halfsize of bilboard,meters)
 float      b = fract(gl_PositionIn[0].w*1.0e-3);
 float      a = lhtpos.w*mix(6.28/(3600.*12.),6.28/(3600.*2.),b);
 cs           = vec4(cos(a),sin(a),cos(b),sin(b));
 emit(gl_PositionIn[0].xyz,vec2(-1.,-1.),rad);
 emit(gl_PositionIn[0].xyz,vec2( 1.,-1.),rad);
 emit(gl_PositionIn[0].xyz,vec2(-1., 1.),rad);
 emit(gl_PositionIn[0].xyz,vec2( 1., 1.),rad);
 EndPrimitive();
}

