// version 1
in      vec2 pos;
out     vec2 p; // [-0.5;0,5]*ratio, [-0.5;0,5]
out     vec2 tc;
out     vec2 sunpos;
out     vec3 power;
#ifdef msaa
uniform sampler2DMS   tex0;   // screen
#else
uniform sampler2DRect tex0;   // screen
#endif
uniform sampler2DRect tex1; // sunpos
uniform vec4        aratio; // alpha,screen_nx/screen_ny,lensflare_power,fade
const float sun_power=0.2;

// pos - [-1;1]
void main()
{
 gl_Position = vec4(pos.xy,0.0,1.0);
 p.x         = pos.x*0.5*aratio.y;
 p.y         = pos.y*0.5;  //  [-0.5;0.5]
 tc          = (pos+1.0)*vec2(textureSize(tex0))*0.5;
 vec3 t      = texelFetch(tex1,ivec2(0,0)).xyz; // sunpos
 sunpos.x    = t.x*aratio.y;
 sunpos.y    = t.y;
 power.x     = min(1.0,t.z)*aratio.z;
 power.y     = smoothstep(0.025,0.1,t.z);
 power.z     = 1.0/max(0.01,t.z*sun_power);
}
