const float tau = 6.28318530717958647692;

// Gamma correction
#define GAMMA (2.2)

vec3 ToLinear( in vec3 col )
{
  // simulate a monitor, converting colour values into light values
  return pow( col, vec3(GAMMA) );
}

vec3 ToGamma( in vec3 col )
{
  // convert back into colour values, so the correct light will come out of the monitor
  return pow( col, vec3(1.0/GAMMA) );
}

vec4 Noise( in ivec2 x )
{
  return texture( iChannel0, (vec2(x)+0.5)/256.0, -100.0 );
}

vec4 Rand( in int x )
{
  vec2 uv;
  uv.x = (float(x)+0.5)/256.0;
  uv.y = (floor(uv.x)+0.5)/256.0;
  return texture( iChannel0, uv, -100.0 );
}


void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
  vec3 ray;
  ray.xy = 2.0*(fragCoord.xy-iResolution.xy*.5)/iResolution.x;
  ray.z = 1.0;

  float offset = iGlobalTime*.15;
  float speed = .5;
  vec3 col = vec3(0);
  vec3 stp = ray/max(abs(ray.x),abs(ray.y));

  vec3 pos = 2.0*stp+.5;
  for ( int i=0; i < 20; i++ )
  {
    float z = Noise(ivec2(pos.xy)).x;
    z = fract(z-offset);
    float d = 50.0*z-pos.z;
    float w = max(0.0,1.0-8.0*length(fract(pos.xy)-.5));
    vec3 c = max(vec3(0.0),vec3(1.0-abs(d)/speed));
    col += 1.5*(1.0-z)*c*w;
    pos += stp;
  }

  float rdl=normalize(ray).z;
  col += .8*vec3(.7,.7,.9)*exp2(rdl*650.-650.);
  col += .3*vec3(.5,.5,.9)*exp2(rdl*100.-100.);
  col += .5*vec3(.9,.9,.9)*exp2(rdl*50.-50.);
  col += .4*vec3(.4,.4,.5)*exp2(rdl*10.-10.);

  fragColor.rgb = col;
  fragColor.a = max(0.0,1.0-length(ray.xy));
}

