vec4 doit( in vec2 pix )
{
    vec2 p = -1.0 + 2.0*pix;
    p.x *= iResolution.x/iResolution.y;

    vec3 ro = vec3( 0.0, 0.0, 2.5 );
    vec3 rd = normalize( vec3( p, -2.0 ) );

    vec4 col;

    // intersect sphere
    float b = dot(ro,rd);
    float c = dot(ro,ro) - 1.0;
    float h = b*b - c;
    if( h>0.0 )
    {
        float t = -b - sqrt(h);
        vec3 pos = ro + t*rd;
        vec3 nor = pos;

        // texture mapping
        vec2 uv;
        uv.x = atan(nor.x,nor.z)/2. - 0.1*iGlobalTime;
        uv.y = acos(nor.y);
		uv.y *= 0.5;
        col.rgb = texture2D( iChannel0, uv ).xyz;

		col.rgb = max(col.rgb,vec3(80./255.,80./255.,160./255.)*smoothstep(0.7,0.9,1.0-col.x));
        
	
        // lighting
        col.rgb *= 0.1 + 0.9*max(nor.x*2.0+nor.z,0.0);
        col.a=1.0;
    }
	else
	{
		c = dot(ro,ro) - 10.0;
		h = b*b - c;
        float t = -b - sqrt(h);
        vec3 pos = ro + t*rd;
        vec3 nor = pos;

        vec2 uv;
        uv.x = 16.0*atan(nor.x,nor.z)/6.2831 - 0.03*iGlobalTime;
        uv.y = 2.0*acos(nor.y)/3.1416;
        col.rgb = pow(texture2D( iChannel0, uv*2.).xyz,vec3(8.0));
        col.a=0.2;

	}
	
    col = 0.5*(col+sqrt(col));
    return col;
}

void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec4 col0 = doit( (fragCoord.xy+vec2(0.0,0.0) )/iResolution.xy );
    vec4 col1 = doit( (fragCoord.xy+vec2(0.5,0.0) )/iResolution.xy );
    vec4 col2 = doit( (fragCoord.xy+vec2(0.0,0.5) )/iResolution.xy );
    vec4 col3 = doit( (fragCoord.xy+vec2(0.5,0.5) )/iResolution.xy );
    vec4 col = 0.25*(col0 + col1 + col2 + col3);
    fragColor = col;
}