#extension GL_EXT_geometry_shader4 : enable
layout (points) in;
layout (triangle_strip, max_vertices = 4) out;

uniform sampler2D tex0;
uniform mat4 modelview;
uniform mat4 projection;
uniform vec4 param;  // velocity,maxdist,time,scr_nx
uniform vec3 cam;
uniform vec2 ring;
uniform vec3 planet;

#define velocity param.x
#define maxdist  param.y
#define time     param.z
#define scr_nx   param.w
#define rocksize cam.z

flat out float seed;
flat out float ratio;
flat out vec4  rcol;
flat out vec4 camera,cs;
out vec2 vx;

void  emit(vec4 p,vec2 d,float size)
{
 vx   =d;
 p.xy+=d*size;
 gl_Position = projection*p;
 EmitVertex();
}

void main()
{
 vec4            p  =  modelview*vec4(gl_PositionIn[0].xyz,1.0);
 float  dist2planet =  distance(p.xyz,planet);
 float            r =  (dist2planet-ring.x)/ring.y;
 rcol               =  texture(tex0,vec2(clamp(r,0.,1.),0.0));
 float  size        =  gl_PositionIn[0].w*rocksize*rcol.a;
 float  dist2cam    =  length(p.xyz);
 // rcol.a       =  smoothstep(2.,16.,size*scr_nx/dist2cam);
 rcol.a       =  smoothstep(0.,1.,1.-dist2cam/maxdist);
 ratio        =  (1.2-gl_PositionIn[0].w)*.8;
 seed         =  gl_PositionIn[0].w;
 camera.xyz   = -p.xyz;
 camera.w     =  1./max(1.,size);
 float      a =  time*mix(-1.,1.,seed);
 cs           =  vec4(cos(a),sin(a),cos(a*.3),sin(a*.3));
 emit(p,vec2(-1.,-1.),size);
 emit(p,vec2( 1.,-1.),size);
 emit(p,vec2(-1., 1.),size);
 emit(p,vec2( 1., 1.),size);
 EndPrimitive();
}

