uniform vec4 param;  // velocity,maxdist,time,scr_nx
uniform vec3 cam;

#define velocity param.x
#define maxdist  param.y
#define time     param.z
#define scr_nx   param.w
#define rocksize cam.z

in  vec4 pos;
void main()
{
 vec2 v       = pos.xy;
 v.y         -= velocity*time;
 v.xy         = mod(v.xy-(cam.xy-maxdist),maxdist*2.)+(cam.xy-maxdist);
 gl_Position  = vec4(v.xy,pos.zw);
}
