version 5
uniform vec3  campos;
uniform vec3  sunDir;
uniform vec3  bl;  // blend,light,planet
out vec4 fragcolor;

#define planet bl.z

in vec3 viewDir;

void main()
{
 vec3 inscatter = skyRadiance(campos,length(campos), normalize(viewDir), sunDir);   // earth, saturn
 if (planet==1.0) inscatter.rgb  = inscatter.bbb*vec3(1.,0.7,.1)*.5; // venus
 if (planet==3.0) inscatter.rgb  = inscatter.bbb*vec3(1.,0.8,.5)*.5+inscatter.ggg*vec3(0.1,0.1,.15);  // mars
 if (planet==7.0) inscatter.rgb  = inscatter.bbb*vec3(0.5,0.5,1.); // neptun
 fragcolor.rgb  = hdr(inscatter)*bl.y;
 fragcolor.a    = bl.x;
}
