version 5
const float sphere_nx=128.0;
const float pi = 3.14159265358979323846;
const float  k = 2.0*pi/sphere_nx;
const vec2   s = vec2(pi,pi*0.5);
uniform mat4 modelproj;
in   vec2    pos;
out vec3     viewDir;
void main()
{
 vec2  ll       = pos.xy*k-s;
 vec2  Sin      = sin(ll);
 vec2  Cos      = cos(ll);
 vec4  v        = vec4( Cos.y * Cos.x , Cos.y * Sin.x , Sin.y , 1.0);
 gl_Position    = modelproj*v;
 viewDir        = v.xyz;
}
