version 6
uniform sampler2D tex7;
uniform vec4  campos;
uniform vec3  sunDir;
out vec4 fragcolor;
in vec3 viewDir;
in  vec2 tc;

void main()
{
 float        r = length(campos.xyz);
 float    blend = clamp((r-athmoHeight-earthRadius)/athmoHeight,0.0,1.0);
 vec3 viewDirn  = normalize(viewDir);
 vec3 inscatter = skyRadiance(campos.xyz,r, viewDirn, sunDir);
 float        a = max(0.1,(1.0+dot(campos.xyz,viewDirn) / r));
 vec4       tcol= texture(tex7, tc.xy);
 tcol.rgb      *= tcol.a;
 tcol.a         = dot(tcol.rgb,vec3(0.299,0.587,0.114));
 vec3       col = hdr(inscatter);
 float alpha    = (tcol.a*(1.0-a)+min(a,0.5))*blend;
 fragcolor.rgb  = col+tcol.rgb*col.b;
 fragcolor.a    = alpha;
}



