version 6
uniform vec4  campos;
uniform vec3  sunDir;
out vec4 fragcolor;
in vec3 viewDir;

void main()
{
 float        r = length(campos.xyz);
 float    blend = clamp((r-athmoHeight-earthRadius)/athmoHeight,0.0,1.0);
 vec3 viewDirn  = normalize(viewDir);
 vec3 inscatter = skyRadiance(campos.xyz,r, viewDirn, sunDir);
 fragcolor.rgb  = hdr(inscatter);
 fragcolor.a    = clamp(1.0+dot(campos.xyz,viewDirn) / r,0.1,0.5)*blend;
}



