version 6

const float earthRadius = 6360010.0;
const float Rt = 6420000.0;

const float sphere_nx=128.0;
const float pi = 3.14159265358979323846;
const float  k = 2.0*pi/sphere_nx;
const vec2   s = vec2(pi,pi*0.5);
uniform vec4 campos;
uniform mat4 modelview;
uniform mat4 projection;
in   vec2    pos;
out vec3     viewDir;
void main()
{
 float radius   = 0.001*(length(campos.xyz)-earthRadius)+Rt;
 vec2  ll       = pos.xy*k-s;
 vec2  Sin      = sin(ll);
 vec2  Cos      = cos(ll);
 vec4  v        = vec4( Cos.y * Cos.x , Cos.y * Sin.x , Sin.y , 1.0);
 vec4  vx       = vec4(v.xyz*radius,1.0);
 vec4  vc       = modelview*vx;
 gl_Position    = projection*vec4(vc.xyz*campos.w,vc.w);
 viewDir        = vx.xyz-campos.xyz;
}
